%MACRO I0V07ED2(AGERTI=, AGEMCE=, SEX=, ICD0= );
 **********************************************************************
 1 MACRO NAME: I0V07ED2
               UDXG update V0323 for V07 HHS model FY23 valid codes
               
 2 PURPOSE:    age/sex edits on &ICD0 - are based on:
               1. RTI age/sex splits
               2. MCE list to check if age or sex
                is within the range of acceptable age/sex, if not- CC
                is set to -1.0 - invalid

 3 PARAMETERS: AGERTI- age for CC splits (=AGE_LAST)
               AGEMCE- age for MCE edits (=AGE_AT_DIAGNOSIS)
               SEX   - SEX
               &ICD0  - diagnosis variable in a diagnosis file
 4 COMMENTS:   
               1.Age format AGEFMT0 and sex format SEXFMT0 are
                 parameters in the main macro. They must correspond
                 to the years of data
               2.If &ICD0 code does not have any restriction on age
                 or sex then the corresponding format puts it in "-1"
               3.Changes in format names 
                 AGE_2020_L format sets lower limits for age
                 AGE_2020_U format sets upper limit for age
                 for specific edit categories:
                 "0"= "0 newborn (age 0)     "
                 "1"= "1 pediatric (age 0-17)"
                 "2"= "2 maternity (age 9-64)" changed in FY20 from 12-55
                 "3"= "3 adult (age 15+)     "   
               4. Code for this macro comes from output of
                  master_UDXGV0323_hhs_HCCV07_SoftEditMacroPrep.sas and
                  master_UDXGV0323_hhs_HCCV07_SoftEditMacroPrep_patch.sas
               5. ICD10 for payment HCCs only are present in the macro 
 **********************************************************************;
 * RTI age/sex splits;
 * codes are not cross-walked to CC if age condition is not met;
 IF &AGERTI < 18  and
    &ICD0 IN ("C9100","C9101","C9102",
              "C9500","C9501","C9502",
              "C7400","C7401","C7402","C7410","C7411","C7412",
              "C7490","C7491","C7492"
               )
 THEN CC="9" ; /*Split acute lymphoid and other acute 
 leukemias, except  myeloid diagnoses to age 18+ (HCC 8) 
 and age <18 (HCC 9). Split adrenal gland cancer diagnoses
 to age 18+ (HCC 10) and age <18 (HCC 9).*/

 ELSE
 IF &AGERTI < 18  and
    &ICD0 IN ("J410","J411","J418","J42","J440","J441" )
 THEN CC="161_1" ; /*Split chronic bronchitis diagnoses to age 18+ 
 (HCC 160) and age <18 (HCC 161.1).*/

 ELSE
 IF &AGERTI < 2  and
    &ICD0 IN (         "K55011","K55012","K55019","K55021","K55022",
              "K55029","K55031","K55032","K55039","K55041","K55042",
              "K55049","K55051","K55052","K55059","K55061","K55062",
              "K55069","K5530", "K5531", "K5532", "K5533" ) 
 THEN CC="42" ; /*Split acute vascular insufficiency of intestine 
 diagnosis to age 2+ (HCC 154) and age <2 (HCC 42).*/

 ELSE
 IF &AGERTI < 50  and
    &ICD0 IN ("C50011","C50012","C50019","C50021","C50022","C50029",
              "C50111","C50112","C50119","C50121","C50122","C50129",
              "C50211","C50212","C50219","C50221","C50222","C50229",
              "C50311","C50312","C50319","C50321","C50322","C50329",
              "C50411","C50412","C50419","C50421","C50422","C50429",
              "C50511","C50512","C50519","C50521","C50522","C50529",
              "C50611","C50612","C50619","C50621","C50622","C50629",
              "C50811","C50812","C50819","C50821","C50822","C50829",
              "C50911","C50912","C50919","C50921","C50922","C50929" )
 THEN CC="11" ; /*Split breast cancer diagnoses to age 50+ (HCC 12) 
 and age <50 (HCC 11).*/

 ELSE
 IF &AGERTI < 2  and
      &ICD0 IN 
      ("J430",   "J431",   "J432",   "J438",   "J439",   "J449",
       "J982",   "J983",                                 
       "F200",   "F201",   "F202",   "F203",   "F205",   "F2081",
       "F2089",  "F209",   "F21",    "F22",    "F23",    "F24",  
       "F250",   "F251",   "F258",   "F259",   "F28",    "F29",  
       "F3010",  "F3011",  "F3012",  "F3013",  "F302",   "F303", 
       "F304",   "F308",   "F309",   "F310",   "F3110",  "F3111",
       "F3112",  "F3113",  "F312",   "F3130",  "F3131",  "F3132",
       "F314",   "F315",   "F3160",  "F3161",  "F3162",  "F3163",
       "F3164",  "F3170",  "F3171",  "F3172",  "F3173",  "F3174",
       "F3175",  "F3176",  "F3177",  "F3178",  "F3181",  "F3189",
       "F319",   "F322",   "F323",   "F332",   "F333",   "F440", 
       "F441",   "F4481",  "F481",   "F5000",  "F5001",  "F5002",
       "F502",   "F600",   "F601",   "F602",   "F603",   "F604", 
       "F605",   "F606",   "F607",   "F6081",  "F6089",  "F609", 
       "G47411", "G47419" ,"G47421" ,"G47429",
       "R4588",  "T1491XA","T360X2A","T361X2A","T362X2A","T363X2A",
       "T364X2A","T365X2A","T366X2A","T367X2A","T368X2A","T3692XA",
       "T370X2A","T371X2A","T372X2A","T373X2A","T374X2A","T375X2A",
       "T378X2A","T3792XA","T380X2A","T381X2A","T382X2A","T383X2A",
       "T384X2A","T385X2A","T386X2A","T387X2A","T38802A","T38812A",
       "T38892A","T38902A","T38992A","T39012A","T39092A","T391X2A",
       "T392X2A","T39312A","T39392A","T394X2A","T398X2A","T3992XA",
       "T400X2A","T401X2A","T402X2A","T403X2A","T40412A","T40422A",
       "T40492A","T405X2A","T40602A","T40692A","T40712A","T40722A",
       "T408X2A","T40902A","T40992A","T410X2A","T411X2A","T41202A",
       "T41292A","T413X2A","T4142XA","T415X2A","T420X2A","T421X2A",
       "T422X2A","T423X2A","T424X2A","T425X2A","T426X2A","T4272XA",
       "T428X2A","T43012A","T43022A","T431X2A","T43202A","T43212A",
       "T43222A","T43292A","T433X2A","T434X2A","T43502A","T43592A",
       "T43602A","T43612A","T43622A","T43632A","T43642A","T43652A",
       "T43692A","T438X2A","T4392XA","T440X2A","T441X2A","T442X2A",
       "T443X2A","T444X2A","T445X2A","T446X2A","T447X2A","T448X2A",
       "T44902A","T44992A","T450X2A","T451X2A","T452X2A","T453X2A",
       "T454X2A","T45512A","T45522A","T45602A","T45612A","T45622A",
       "T45692A","T457X2A","T458X2A","T4592XA","T460X2A","T461X2A",
       "T462X2A","T463X2A","T464X2A","T465X2A","T466X2A","T467X2A",
       "T468X2A","T46902A","T46992A","T470X2A","T471X2A","T472X2A",
       "T473X2A","T474X2A","T475X2A","T476X2A","T477X2A","T478X2A",
       "T4792XA","T480X2A","T481X2A","T48202A","T48292A","T483X2A",
       "T484X2A","T485X2A","T486X2A","T48902A","T48992A","T490X2A",
       "T491X2A","T492X2A","T493X2A","T494X2A","T495X2A","T496X2A",
       "T497X2A","T498X2A","T4992XA","T500X2A","T501X2A","T502X2A",
       "T503X2A","T504X2A","T505X2A","T506X2A","T507X2A","T508X2A",
       "T50902A","T50912A","T50992A","T50A12A","T50A22A","T50A92A",
       "T50B12A","T50B92A","T50Z12A","T50Z92A","T510X2A","T511X2A",
       "T512X2A","T513X2A","T518X2A","T5192XA","T520X2A","T521X2A",
       "T522X2A","T523X2A","T524X2A","T528X2A","T5292XA","T530X2A",
       "T531X2A","T532X2A","T533X2A","T534X2A","T535X2A","T536X2A",
       "T537X2A","T5392XA","T540X2A","T541X2A","T542X2A","T543X2A",
       "T5492XA","T550X2A","T551X2A","T560X2A","T561X2A","T562X2A",
       "T563X2A","T564X2A","T565X2A","T566X2A","T567X2A","T56812A",
       "T56892A","T5692XA","T570X2A","T571X2A","T572X2A","T573X2A",
       "T578X2A","T5792XA","T5802XA","T5812XA","T582X2A","T588X2A",
       "T5892XA","T590X2A","T591X2A","T592X2A","T593X2A","T594X2A",
       "T595X2A","T596X2A","T597X2A","T59812A","T59892A","T5992XA",
       "T600X2A","T601X2A","T602X2A","T603X2A","T604X2A","T608X2A",
       "T6092XA","T6102XA","T6112XA","T61772A","T61782A","T618X2A",
       "T6192XA","T620X2A","T621X2A","T622X2A","T628X2A","T6292XA",
       "T63002A","T63012A","T63022A","T63032A","T63042A","T63062A",
       "T63072A","T63082A","T63092A","T63112A","T63122A","T63192A",
       "T632X2A","T63302A","T63312A","T63322A","T63332A","T63392A",
       "T63412A","T63422A","T63432A","T63442A","T63452A","T63462A",
       "T63482A","T63512A","T63592A","T63612A","T63622A","T63632A",
       "T63692A","T63712A","T63792A","T63812A","T63822A","T63832A",
       "T63892A","T6392XA","T6402XA","T6482XA","T650X2A","T651X2A",
       "T65212A","T65222A","T65292A","T653X2A","T654X2A","T655X2A",
       "T656X2A","T65812A","T65822A","T65832A","T65892A","T6592XA",
       "T71112A","T71122A","T71132A","T71152A","T71162A","T71192A",
       "T71222A","T71232A","X710XXA","X711XXA","X712XXA","X713XXA",
       "X718XXA","X719XXA","X72XXXA","X730XXA","X731XXA","X732XXA",
       "X738XXA","X739XXA","X7401XA","X7402XA","X7409XA","X748XXA",
       "X749XXA","X75XXXA","X76XXXA","X770XXA","X771XXA","X772XXA",
       "X773XXA","X778XXA","X779XXA","X780XXA","X781XXA","X782XXA",
       "X788XXA","X789XXA","X79XXXA","X80XXXA","X810XXA","X811XXA",
       "X818XXA","X820XXA","X821XXA","X822XXA","X828XXA","X830XXA",
       "X831XXA","X832XXA","X838XXA" )
 THEN CC="-1.0" ; /*Split emphysema diagnoses to age 18+ (HCC 160) 
 and age 2-17 (HCC160; split not needed in HHS model). 
 If age <2 out of payment model. Edit for narcolepsy and psychiatric 
 conditions excluded from infant model. If age <2 out of payment model.*/    

 ELSE
 IF &AGERTI < 21  and
    &ICD0 IN ("H353210","H353211","H353212","H353213",
              "H353220","H353221","H353222","H353223",
              "H353230","H353231","H353232","H353233",
              "H353290","H353291","H353292","H353293" )
    THEN CC="-1.0" ; /*Edit for exudative age-related macular degeneration. 
    If age <21 out of payment model.*/

 ELSE
 IF &AGERTI ne 0  and
    &ICD0 IN ("P0500","P0501","P0502","P0503","P0504","P0505",
              "P0506","P0507","P0508","P0509","P0510","P0511",
              "P0512","P0513","P0514","P0515","P0516","P0517",
              "P0518","P0519","P052", "P059", "P0700","P0701",
              "P0702","P0703","P0710","P0714","P0715","P0716",
              "P0717","P0718","P0720","P0721","P0722","P0723",
              "P0724","P0725","P0726","P0730","P0731","P0732",
              "P0733","P0734","P0735","P0736","P0737","P0738",
              "P0739","P080", "P081", "P0821","P0822",
              "Z3800","Z3801","Z381", "Z382", "Z3830",
              "Z3831","Z384", "Z385", "Z3861","Z3862",
              "Z3863","Z3864","Z3865","Z3866","Z3868",
              "Z3869","Z387", "Z388" )
 THEN CC="-1.0" ; /*Edit for newborn low birthweight or birth status. 
  If age 1+ out of payment model.*/

 ELSE
 IF &AGERTI >= 1  and
    &ICD0 IN ("Q894" )
 THEN CC="97" ; /*Split conjoined twins diagnoses to age 1+ (HCC 97) 
 and age <1 (HCC 247).*/

 ELSE    
 IF &AGERTI >= 2  and &ICD0 IN ("K551","K558","K559",
              "P040", "P0411","P0412","P0413","P0414","P0415",
              "P0416","P0417","P0418","P0419","P041A",
              "P042", "P043", "P0440","P0441","P0442","P0449",
              "P045", "P046",         "P0481","P0489",
              "P049", "P930", "P938", "P961", "P962",
              "Q390", "Q391", "Q392", "Q393", "Q394", "Q6410",
              "Q6411","Q6412","Q6419","Q790", "Q791", "Q792",
              "Q793", "Q794", "Q7951" )
 THEN CC="-1.0" ; /*If age 2+ out of payment model.*/

 ELSE
 IF &AGERTI >= 2  and
    &ICD0 IN ("P270","P271","P278","P279" )
 THEN CC="162" ; /*Split chronic respiratory disease arising in the 
 perinatal period diagnoses to age 2+ (HCC 162) and age <2 (HCC 127).*/

 ELSE
 IF (&AGERTI < 6 or &AGERTI > 18 ) and
    &ICD0 in ("F3481")
 THEN CC="-1.0" ; /*Edit for targeted age of diagnosis. If age <6 or age >18 out of payment model.*/

 ELSE
 IF &AGERTI >= 21  and
    &ICD0 IN ("E700",  "E701",  "E7020", "E7021", "E7029", "E7030", 
              "E70310","E70311","E70318","E70319","E70320","E70321",
              "E70328","E70329","E70330","E70331","E70338","E70339",
              "E7039", "E7040", "E7041", "E7049", "E705",  "E7081", 
              "E7089", "E709",  "E710",  "E71110","E71111","E71118",
              "E71120","E71121","E71128","E7119", "E712",  "E7130", 
              "E71310","E71311","E71312","E71313","E71314","E71318",
              "E7132", "E7139", "E7142", "E7150", "E71510","E71511",
              "E71518","E71520","E71521","E71522","E71528","E71529",
              "E7153", "E71540","E71541","E71542","E71548","E7200", 
              "E7201", "E7202", "E7203", "E7204", "E7209", "E7210", 
              "E7211", "E7212", "E7219", "E7220", "E7221", "E7222", 
              "E7223", "E7229", "E723",  "E724",  "E7250", "E7251", 
              "E7252", "E7253", "E7259", "E7281", "E7289", "E729",  
              "E7420", "E7421", "E7429", "E744",  "E74810","E74818",
              "E74819","E7489", "E749",  "E771",  "E8840", "E8841", 
              "E8842", "E8849", "H49811","H49812","H49813","H49819" )
    THEN CC="-1.0" ; /*Edit for congenital metabolic disorders. If age >=21 out of payment model.*/

 ELSE 
 IF &SEX="2"  and
    &ICD0 IN ("D66","D67" )
 THEN CC="75" ; /*Split hemophilia diagnoses to male (HCC 66 if age <65 
 or HCC 66 if age 65+; age split not needed in HHS model) 
 and female (HCC 75).*/

 /* patch */
 ELSE
 IF &AGERTI < 21  and
    &ICD0 IN ("E10641","E1011","E1010") 
    THEN CC="19" ; /*Split for type 1 diabetes with acute 
    complications to age 21+ (HCC 19 and add-on HCC 22) 
    and age <21 (HCC 19).*/

 ELSE
 IF &AGERTI < 21  and
    &ICD0 IN ("E1022",  "E1029",  "E1021",  "E1052",  "E1059",   
              "E1051",  "E1041",  "E1049",  "E1044",  "E1040",  
              "E1043",  "E1042",  "E10610", "E10621", "E10620", 
              "E10622", "E10618", "E10628", "E10638", "E10630", 
              "E1069",  "E103591","E103412","E103593","E103559",
              "E103291","E103552","E103549","E103393","E103542",
              "E103539","E10311", "E103219","E103391","E103532",
              "E103529","E103531","E103533","E103392","E103541",
              "E103543","E103399","E103551","E10319", "E103553",
              "E103411","E103292","E103592","E103413","E103599",
              "E103523","E103213","E103319","E103522","E103521",
              "E103313","E103519","E103513","E103212","E103312",
              "E103512","E103511","E103311","E103499","E103211",
              "E103493","E103492","E1039",  "E103299","E103491",
              "E1037X9","E1037X3","E1037X2","E1037X1","E103293",
              "E103419","E1036")   
    THEN CC="20" ; /*Split for type 1 diabetes with chronic 
    complications to age 21+ (HCC 20 and add-on HCC 22) 
    and age <21 (HCC 20).*/

 ELSE
 IF &AGERTI < 21  and
    &ICD0 IN ("E108","E1065","E10649","E109")  
    THEN CC="21" ; /*Split for type 1 diabetes without complication 
    to age 21+ (HCC 21 and add-on HCC 22) and age <21 (HCC 21).*/


 * MCE edits;
 * check if age is within acceptable range;
 _tage=put(&ICD0, $&AGEFMT0..);
 if _tage ne "-1" and
  (&AGEMCE < input(put(_tage, $AGE_2020_L.),8.) or
   &AGEMCE > input(put(_tage, $AGE_2020_U.),8.)) then cc="-1.0";
 * check if sex for a person is the one in the MCE file;
 _tsex=put(&ICD0, $&SEXFMT0..);
 if _tsex ne "-1"  and _tsex ne &SEX then cc="-1.0";

 %MEND I0V07ED2;








